clear all;
close all;
clc;

% Numerical optimization and output tracking based ESC for feedback
% linearizable systems
% line search based ESC

% define the global variable
global k1 k icon rho w  xs xsr tstart grad dt CovnT DeltaT ts tsr lambda;
global usave tsave

usave=[]; tsave=[];

k1=2;
k=3;

icon=1; % Choice of cost function 
        % 0 --- J(x)=5 x_1^2 + x_2^2 + 4x_1x_2-14x_1-6x_2+20.
        % 1 --- Banana Function
        % 2 --- Normlized Banana Function

% % banana function
% t0=0;  % start time
% t1=30;  % end time
% tstart=0;
% dt=0;
% CovnT=0.1;
% lambda=-5;
% ts=3;
% DeltaT=10;

% Banana Function new system
t0=0;  % start time
t1=15;  % end time
tstart=0;
dt=0;
CovnT=0.2;
lambda=-5;
ts=1;
%DeltaT=1;


% t0=0;  % start time
% t1=100;  % end time
% tstart=0;
% dt=0;
% CovnT=0.5;
% lambda=-5;
% ts=1;
% DeltaT=10;



%initial condition of the state 
if icon==1 
   x0=[-1.9;0];   % banana function
else
   x0=[-10;10];   % another cost function
end
xsr(:,1)=x0;   % desired regulated state
tsr(:,1)=t0;

rho=0.4;       % constant in Armijo condition
w=0.5;         % step size retraction factor

% solving the ode
tspan=[t0 t1];    
%tspan = t0:(t1-t0)/100:t1;
rand('state',0);  
options = odeset('OutputFcn','odeplot', 'OutputSel', [1,2]);
[t,x]=ode23('ltiesc_steep_derivatives_trackr',tspan,x0, options);    
for i=1:length(t)
    idx = find(tsave-t(i)==0);
    u(i)=usave(idx(length(idx)));
end;
    

% trajectory of the states
x1=x(:,1);
x2=x(:,2);

% trajectory of the output banana function
if icon==1
   y=100*(x2-x1.^2).^2+(2-x1).^2;
elseif icon==0
   y=5.*x1.^2+x2.^2+4.*x1.*x2-14*x1-6*x2+20;
else
   y=(x1-2).^2+(x2-3).^2;
end

figure 
plot(t,y,'r','LineWidth',3);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('output','FontSize',18,'FontWeight','bold');
%title('Objective Function','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
saveas(gcf,'output_norm.eps','psc2');


figure
plot(t,x1,t,x2,'r','LineWidth',3);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('states','FontSize',18,'FontWeight','bold');
legend('x_1','x_2');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
%axis([0 10 -1 1]
saveas(gcf,'state_norm.eps','psc2');


figure
plot(t,u,'LineWidth',3);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('Input','FontSize',18,'FontWeight','bold');
grid on;  set(gca,'FontSize',12,'FontWeight','bold');  
saveas(gcf,'control_norm.eps','psc2');


if icon==1
   % plot the contour of the banana function
   [x1, x2]=meshgrid(-2:0.01:2, -1:0.01:3);
   ros=100*(x2-x1.^2).^2+(1-x1).^2;
   figure;
   height=[0:0.5:2];
   contour(x1,x2,ros,height); 
   hold on;
   height=[2:5:20];
   contour(x1,x2,ros,height);
   height=[20:50:600];
   contour(x1,x2,ros,height);
   xlabel('x_1','FontSize',18,'FontWeight','bold');
   ylabel('x_2','FontSize',18,'FontWeight','bold');
   title('Contour of the Rosenbrock Function','FontSize',18,'FontWeight','bold');
   hold on;
   set(gca,'FontSize',12,'FontWeight','bold'); 
   plot(1,1,'*','MarkerSize',10,'LineWidth',2);
elseif icon==0
   % plot the contour of anthor cost function
   x1=linspace(-15,15,100);
   x2=x1;
   [X1,X2]=meshgrid(x1,x2);
   Z=5.*(X1.^2)+X2.^2+4.*X1.*X2-14.*X1-6.*X2+20;
   figure
   v= exp(0:0.2:10);
   contour(X1,X2,Z,v);
   title('Contour of the Quadratic Function','FontSize',18,'FontWeight','bold');
   set(gca,'FontSize',12,'FontWeight','bold'); 
   hold on;
   %plot(1,1,'*','MarkerSize',10,'LineWidth',2);
else
   x1=linspace(-15,15,100);
   x2=x1;
   [X1,X2]=meshgrid(x1,x2);
   Z=(X1-2).^2+(X2-3).^2;;
   figure;
   v= exp(0:0.2:10);
   contour(X1,X2,Z,v);
   title('Contour of the Quadratic Function','FontSize',18,'FontWeight','bold');
   set(gca,'FontSize',12,'FontWeight','bold'); 
   hold on;
   plot(2,3,'*','MarkerSize',10,'LineWidth',2); 
end

plot(xsr(1,:),xsr(2,:),'o','MarkerEdgeColor','b','MarkerFaceColor',[.49 1 .63], 'MarkerSize',12,'LineWidth',3);
hold on
plot(x(:,1),x(:,2),'r--','LineWidth',3);
%legend('contour','x_k','x_k hat','x')
%legend('contour of banana function','steep descent sequence','state trajectory')
%grid on;  
xlabel('x_1','FontSize',18,'FontWeight','bold');
ylabel('x_2','FontSize',18,'FontWeight','bold');
set(gca,'FontSize',12,'FontWeight','bold'); 
%text(-1.95,-0.1,'start point','FontSize',12,'FontWeight','bold'); 
%text(1,1.1,'minimizer','FontSize',12,'FontWeight','bold'); 
%text(-1.5,0.8,'state trajectory','FontSize',12,'FontWeight','bold'); 
saveas(gcf,'phase_norm.eps','psc2');

 
